* compare recessions (figures 2 and 3)

/* compare variables from all recessions on one graph */
/* need to generate a variable which is number of quarters into recession
   use dates in SVR
   can't let recessions overlap, so use one variable (also need only one in
   order to plot), not one variable per recession, though to start might be
   useful to have one per recession */

* in figure 3 do productivity, so calculate
gen prodvy=gdp_r/hourswork

gen duration=.
label var duration "Duration of recession - quarters"
gen byte recession=.
* Q2 1973-Q2 1975
replace duration=year_q-1973.25 if year_q>=1973.25&year_q<=1975.25
replace recession=1 if year_q>=1973.25&year_q<=1975.25
* Q4 1979-Q4 1982
replace duration=year_q-1979.75 if year_q>=1979.75&year_q<=1982.75
replace recession=2 if year_q>=1979.75&year_q<=1982.75
* Q1 1991-Q3 1993
replace duration=year_q-1991 if year_q>=1991&year_q<=1993.5
replace recession=3 if year_q>=1991&year_q<=1993.5
* Q1 2001-Q2 2005
replace duration=year_q-2001 if year_q>=2001&year_q<=2005.25
replace recession=4 if year_q>=2001&year_q<=2005.25
* Q1 2008-Q2 2009
replace duration=year_q-2008 if year_q>=2008&year_q<=2009.25
replace recession=5 if year_q>=2008&year_q<=2009.25
replace duration=duration*4+1

* need to normalize the variables to 100 at duration=1
* find value at duration=1
gen ngdp_r_temp=gdp_r if duration==1
gen nempl_temp=empl if duration==1
gen nhourswork_temp=hourswork if duration==1
gen nhrsworker_temp=hrsworker if duration==1
gen nprodvy_temp=prodvy if duration==1
* fill in gaps
sort year_q
egen ngdp_r=max(ngdp_r_temp),by(recession)
egen nempl=max(nempl_temp),by(recession)
egen nhourswork=max(nhourswork_temp),by(recession)
egen nhrsworker=max(nhrsworker_temp),by(recession)
egen nprodvy=max(nprodvy_temp),by(recession)
drop ngdp_r_temp nempl_temp nhourswork_temp nhrsworker_temp nprodvy_temp

* generate normalized values
gen gdp_ri=100*(gdp_r/ngdp_r)
gen empli=100*(empl/nempl)
gen hoursworki=100*(hourswork/nhourswork)
gen hrsworkeri=100*(hrsworker/nhrsworker)
gen prodvyi=100*(prodvy/nprodvy)

* figure out share of hours worked decline due to hrs per worker vs bodies
* use start/end of recessions from SVR, which are approx peak-trough of hours
* identify trough
sort year_q
gen byte trough=1 if duration~=.&duration[_n-1]~=.&duration[_n+1]==.
* values of vars at trough
gen thourswork_temp=hourswork if trough==1
gen templ_temp=empl if trough==1
gen thrsworker_temp=hrsworker if trough==1
egen thourswork=max(thourswork_temp),by(recession)
egen templ=max(templ_temp),by(recession)
egen thrsworker=max(thrsworker_temp),by(recession)
drop thourswork_temp thrsworker_temp templ_temp

* calculate peak-to-trough of each
* approximation not so good if don't do in logs, so do in logs
gen ptlhourswork=log(thourswork)-log(hourswork) if duration==1
gen ptlempl=log(templ)-log(empl) if duration==1
gen ptlhrsworker=log(thrsworker)-log(hrsworker) if duration==1
gen hrsworkershare=ptlhrsworker/ptlhourswork

list year quarter  pt*   hrsworkershare if duration==1


/* graphs */
label var duration "Quarters since start of recession"
twoway line gdp_ri duration if year_q>=1973.25&year_q<=1975.25,lcolor(gs0)||line gdp_ri duration if year_q>=1979.75&year_q<=1982.75,lcolor(gs5)||line gdp_ri duration if year_q>=1991&year_q<=1993.5,lcolor(gs0) lpattern(-)||line gdp_ri duration if year_q>=2001&year_q<=2005.25,lcolor(gs5) lpattern(_)||line gdp_ri duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1mono) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(98.3 9 "1973-1975") text(99 13.5 "1979-1982") legend(off) ytick(103) ylabel(92 94 96 98 100 102) text(102.8 5 "1991-1993") text(101.8 16 "2001-2005") text(94.8 7.3 "2008-2009") saving(gdpi,replace) title("A. GDP",position(11) size(medium))

twoway line empli duration if year_q>=1973.25&year_q<=1975.25,lcolor(gs0)||line empli duration if year_q>=1979.75&year_q<=1982.75,lcolor(gs5)||line empli duration if year_q>=1991&year_q<=1993.5,lcolor(gs0) lpattern(-)||line empli duration if year_q>=2001&year_q<=2005.25,lcolor(gs5) lpattern(_)||line empli duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1mono) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(97.7 9.3 "1973-5") text(101 13.5 "1979-1982") legend(off) ytick(103) ylabel(92 94 96 98 100 102) text(97.5 3 "1991-1993") text(99.5 16 "2001-2005") text(100 7.8 "2008-9") saving(empli,replace) title("B. Employment",position(11) size(medium))

twoway line hoursworki duration if year_q>=1973.25&year_q<=1975.25,lcolor(gs0)||line hoursworki duration if year_q>=1979.75&year_q<=1982.75,lcolor(gs5)||line hoursworki duration if year_q>=1991&year_q<=1993.5,lcolor(gs0) lpattern(-)||line hoursworki duration if year_q>=2001&year_q<=2005.25,lcolor(gs5) lpattern(_)||line hoursworki duration if year_q>=2008&year_q<=2009.25, lcolor(gs0) scheme(s1mono) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(93 5.5 "1973-1975") text(99 10.5 "1979-1982") legend(off) ylabel(92 94 96 98 100 102) ytick(103) text(95 11 "1991-1993") text(97.7 16 "2001-2005") text(96.7 2.7 "2008-2009") saving(hoursworki,replace) title("C. Person hours",position(11) size(medium))

graph combine gdpi.gph empli.gph hoursworki.gph,scheme(s1mono) saving(recessions,replace) imargin(tiny)
graph export recessions.eps,replace logo(off) mag(130)

twoway line hrsworkeri duration if year_q>=1973.25&year_q<=1975.25,lcolor(gs0)||line hrsworkeri duration if year_q>=1979.75&year_q<=1982.75,lcolor(gs5)||line hrsworkeri duration if year_q>=1991&year_q<=1993.5,lcolor(gs0) lpattern(-)||line hrsworkeri duration if year_q>=2001&year_q<=2005.25,lcolor(gs5) lpattern(_)||line hrsworkeri duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1mono) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(95.3 9 "1973-1975") text(96 13 "1979-1982") legend(off) ylabel(92 94 96 98 100 102) ytick(103) text(101.3 6 "1991-1993") text(98.5 16 "2001-2005") text(96.3 3 "2008-2009") saving(hrsworkeri,replace) title("A. Hours per worker",position(11) size(medium))

twoway line prodvyi duration if year_q>=1973.25&year_q<=1975.25,lcolor(gs0)||line prodvyi duration if year_q>=1979.75&year_q<=1982.75,lcolor(gs5)||line prodvyi duration if year_q>=1991&year_q<=1993.5,lcolor(gs0) lpattern(-)||line prodvyi duration if year_q>=2001&year_q<=2005.25,lcolor(gs5) lpattern(_)||line prodvyi duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1mono) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(107.5 9 "1973-1975") text(102 12.5 "1979-1982") legend(off) ylabel(96 98 100 102 104 106 108) text(105.8 11 "1991-1993") text(105.3 16 "2001-2005") text(97.5 7 "2008-2009") saving(prodvyi,replace) title("B. Hourly labor productivity",position(11) size(medium))

graph combine hrsworkeri.gph prodvyi.gph,scheme(s1mono) saving(recessions,replace)
graph export recessionsb.eps,replace logo(off) mag(130)

/* graphs for talk */
twoway line gdp_ri duration if year_q>=1973.25&year_q<=1975.25||line gdp_ri duration if year_q>=1979.75&year_q<=1982.75||line gdp_ri duration if year_q>=1991&year_q<=1993.5,lpattern(-)||line gdp_ri duration if year_q>=2001&year_q<=2005.25,lpattern(_)||line gdp_ri duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1color) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(98.3 9 "1973-1975") text(99 13.5 "1979-1982") legend(off) ytick(103) ylabel(92 94 96 98 100 102) text(102.8 5 "1991-1993") text(101.8 16 "2001-2005") text(94.8 7.3 "2008-2009") saving(gdpit,replace)

graph export tfigure2gdp.eps,replace logo(off) mag(130)

twoway line empli duration if year_q>=1973.25&year_q<=1975.25||line empli duration if year_q>=1979.75&year_q<=1982.75||line empli duration if year_q>=1991&year_q<=1993.5,lpattern(-)||line empli duration if year_q>=2001&year_q<=2005.25, lpattern(_)||line empli duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1color) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(97.7 9 "1973-1975") text(101 13.5 "1979-1982") legend(off) ytick(103) ylabel(92 94 96 98 100 102) text(97.5 3 "1991-1993") text(99.5 16 "2001-2005") text(100 7.5 "2008-2009") saving(emplit,replace) 

graph export tfigure2empl.eps,replace logo(off) mag(130)

twoway line hoursworki duration if year_q>=1973.25&year_q<=1975.25||line hoursworki duration if year_q>=1979.75&year_q<=1982.75||line hoursworki duration if year_q>=1991&year_q<=1993.5,lpattern(-)||line hoursworki duration if year_q>=2001&year_q<=2005.25,lpattern(_)||line hoursworki duration if year_q>=2008&year_q<=2009.25, lcolor(gs0) scheme(s1color) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(93 5.5 "1973-1975") text(99 10.5 "1979-1982") legend(off) ylabel(92 94 96 98 100 102) ytick(103) text(95 11 "1991-1993") text(97.7 16 "2001-2005") text(96.7 2.7 "2008-2009") saving(hoursworkit,replace)

graph export tfigure2hours.eps,replace logo(off) mag(130)

twoway line hrsworkeri duration if year_q>=1973.25&year_q<=1975.25||line hrsworkeri duration if year_q>=1979.75&year_q<=1982.75||line hrsworkeri duration if year_q>=1991&year_q<=1993.5,lpattern(-)||line hrsworkeri duration if year_q>=2001&year_q<=2005.25,lpattern(_)||line hrsworkeri duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1color) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(95.3 9 "1973-1975") text(96 13 "1979-1982") legend(off) ylabel(92 94 96 98 100 102) ytick(103) text(101.3 6 "1991-1993") text(98.5 16 "2001-2005") text(96.3 3 "2008-2009") saving(hrsworkerit,replace)

graph export tfigure3hrsworker.eps,replace logo(off) mag(130)

twoway line prodvyi duration if year_q>=1973.25&year_q<=1975.25||line prodvyi duration if year_q>=1979.75&year_q<=1982.75||line prodvyi duration if year_q>=1991&year_q<=1993.5,lpattern(-)||line prodvyi duration if year_q>=2001&year_q<=2005.25,lpattern(_)||line prodvyi duration if year_q>=2008&year_q<=2009.25,lcolor(gs0) scheme(s1color) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(107.5 9 "1973-1975") text(102 12.5 "1979-1982") legend(off) ylabel(96 98 100 102 104 106 108) text(105.8 11 "1991-1993") text(105.3 16 "2001-2005") text(97.5 7 "2008-2009") saving(prodvyit,replace)

graph export tfigure3prodvy.eps,replace logo(off) mag(130)

/*
twoway line hoursworki duration if year_q>=1973.25&year_q<=1975.25||line hoursworki duration if year_q>=1979.75&year_q<=1982.75||line hoursworki duration if year_q>=1991&year_q<=1993.5,lpattern(-)||line hoursworki duration if year_q>=2001&year_q<=2005.25,lpattern(_)||line hoursworki duration if year_q>=2008&year_q<=2009.25, lcolor(gs0) scheme(s1color) ytitle("Start of recession=100") xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) text(93 5.5 "1973-1975") text(99 10.5 "1979-1982") legend(off) ylabel(92 94 96 98 100 102) ytick(103) text(95 11 "1991-1993") text(97.7 16 "2001-2005") text(96.7 2.7 "2008-2009") saving(hoursworkit,replace)

graph export tfigure2hours.eps,replace logo(off) mag(130)

/*
/* by sector: employment */
* do graph for this recession
label var year_q "2008 Recession"
twoway line emplmani emplconsi empltradei emplfini emplservi year_q||if year>=2007,scheme(s1color) saving(sectors08,replace) xlabel(200700 200750 200800 200850 200900 200950 201000 201050,val angle(vertical)) ytitle("Employment, Q1 2007=100") ylabel(97 99 101 103 105 107)

* do graph for 1974-5 recession
label var year_q "1974 Recession"
twoway line emplmani2 emplconsi2 empltradei2 emplfini2 emplservi2 year_q||if year>=1973&year<=1976,scheme(s1color) saving(sectors74,replace) ytitle("Employment, Q1 1973=100") ylabel(85 90 95 100 105 110 115) xlabel(197300 197350 197400 197450 197500 197550 197600 197650,val angle(vertical))

graph combine sectors08.gph sectors74.gph
graph export sectorsempl.eps,replace logo(off) mag(14)

/* by sector: value-added */
label var year_q "2008 Recession"
twoway line vamani vaconsi vatradei vafini vaservi year_q||if year>=2007,scheme(s1color) saving(vsectors08,replace) xlabel(200700 200750 200800 200850 200900 200950 201000 201050,val angle(vertical)) ytitle("Real value Added, Q1 2007=100") ylabel(75 80 85 90 95 100 105 110 115 120 125)

* do graph for 1974-5 recession
label var year_q "1974 Recession"
twoway line vamani2 vaconsi2 vatradei2 vafini2 vaservi2 year_q||if year>=1973&year<=1976,scheme(s1color) saving(vsectors74,replace) ytitle("Real value Added, Q1 1973=100") ylabel(75 80 85 90 95 100 105 110 115 120 125) xlabel(197300 197350 197400 197450 197500 197550 197600 197650,val angle(vertical))

graph combine vsectors08.gph vsectors74.gph
graph export vsectors.eps,replace logo(off) mag(14)
*/
label var year_q "Year"
replace year_q=year_q*100
